import type { Metadata } from 'next'
import { Inter } from 'next/font/google'
import './globals.css'
import Navigation from '@/components/Navigation'
import Footer from '@/components/Footer'

const inter = Inter({ subsets: ['latin'] })

export const metadata: Metadata = {
  title: 'Nine Three Merch - Auto Detailing & Merchandise',
  description: 'Premium auto detailing services and quality merchandise in San Antonio, TX and Roxie, MS. Professional car care and exclusive branded products.',
  keywords: 'auto detailing, car detailing, merchandise, Nine Three Merch, San Antonio, Roxie, car care, auto shop',
  openGraph: {
    title: 'Nine Three Merch',
    description: 'Premium auto detailing services and quality merchandise',
    type: 'website',
  },
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en">
      <body className={inter.className}>
        <Navigation />
        <main className="min-h-screen">
          {children}
        </main>
        <Footer />
      </body>
    </html>
  )
}
